#include <stdarg.h>
#include <stdlib.h>
#include <float.h>

#ifndef WIN32
#include <sys/param.h>
#include <sys/stat.h>
#endif

#ifdef WIN32
#pragma warning(disable: 4190)
#pragma warning(disable: 4800)
#endif /* WIN32 */

#include <maya/MStatus.h>
#include <maya/MObject.h>
#include <maya/MFnPlugin.h>
#include <maya/MString.h>
#include <maya/MStringArray.h>
#include <maya/MPxFileTranslator.h>
#include <maya/MGlobal.h>
#include <maya/MFnDagNode.h>
#include <maya/MItDag.h>
#include <maya/MObject.h>
#include <maya/MPlug.h>
#include <maya/MItSelectionList.h>
#include <maya/MSelectionList.h>
#include <maya/MAnimControl.h>
#include <maya/MDistance.h>
#include <maya/MFnSkinCluster.h>

#include <iostream.h>
#include <fstream.h>
#include <string.h>

#include <MDt.h>
#include <MDtExt.h>

#include "rtimport.h"
#include "material.h"
#include "mayabsp.h"
#include "global.h"

#ifdef WIN32
#define MAXPATHLEN 512
#endif

GlobalData *globalData;

/* ====================================== */
/* Get path name from a full path	 */
/* ====================================== */
char *
MDt_GetPathName (char *LFullStr, char *LRet, int LMaxLen)
{
    register int    LC;
    register int    LLen,
                    LLastSlashPos;

    LLastSlashPos = -1;
    for (LC = 0; LFullStr[LC] != '\0'; LC++)
    {
        if (LFullStr[LC] == '/')
            LLastSlashPos = LC;
    }

    LLen = LLastSlashPos + 1;

    if (LRet == NULL)
        return (NULL);

    LC = 0;
    if ((LRet != NULL) && ((LLen + 1) <= LMaxLen))
    {
        for (; LC < LLen; LC++)
            LRet[LC] = LFullStr[LC];
    }
    LRet[LC] = '\0';

    return (LRet);
}

GlobalData::GlobalData()
{
    m_maxClosestCheck       = 50;
    m_maxPolysPerSector     = 1024;
    m_maxSectorSize         = FLT_MAX;
    m_scaleFactor           = 1.0f;
    m_verbose               = false;
    m_weldThreshold         = 0.001f;
    m_triStrips             = false;
    m_triStripper           = TRISTRIP_DEFAULT;
    m_maxSectorOverlap      = 0.25;
    m_noAlphaInOverlap      = false;
    m_limitUVs              = false;
    m_uvLimit               = 16.0f;
    m_exportNormals         = true;
    m_exportKL              = false;
    m_generateCollision     = true;
}

void* bspTranslator::creator()
{
    return new bspTranslator();
}


/* The reader is not implemented yet. And probably never will be */
MStatus bspTranslator::reader (const MFileObject & file,
                                const MString & options,
                                MPxFileTranslator::FileAccessMode mode)
{
    MStatus rval (MS::kSuccess);

    return rval;
}

/* Write method of the bsp translator / file exporter */
MStatus bspTranslator::writer ( const MFileObject & fileObject,
                                const MString & options,
                                MPxFileTranslator::FileAccessMode mode)
{
    char            LTmpStr[MAXPATHLEN];
    const MString   fname = fileObject.fullName ();
    MString         extension;
    MString         baseFileName;
    char            SceneName[255];
    unsigned int    i;
    int             LN;
    MStatus         status;

    globalData = new GlobalData;

    /* Add the known extension of .bsp if it isn't there. */
    extension.set (".bsp");
    int  extLocation = fileObject.name ().rindex ('.');
    baseFileName = fileObject.name ();

    if (extLocation == 0)
    {
        /* add the extension */
        baseFileName = baseFileName + extension;
    }

    strcpy( SceneName, baseFileName.asChar() );

    /* Process all the options in the options string */	
    if (options.length () > 0)
    {
        /* Parse each option */
        MStringArray optionList;
        MStringArray theOption;

        /* split up all the options.into a string array */
        options.split (';', optionList);

        for (i = 0; i < optionList.length (); ++i)
        {
            theOption.clear ();
            optionList[i].split ('=', theOption);
            if (theOption.length () > 1)
            {
                if (theOption[0] == MString ("bspScaleFactor"))
                {
                    globalData->m_scaleFactor = (float) (theOption[1].asFloat ());

                } else if (theOption[0] == MString ("bspMaxPolygonsPerSector"))
                {
                    globalData->m_maxPolysPerSector = (int) (theOption[1].asInt ());

                } else if (theOption[0] == MString ("bspMaxSectorSize"))
                {
                    globalData->m_maxSectorSize = (float) (theOption[1].asFloat ());

                } else if (theOption[0] == MString ("bspMaxClosestCheck"))
                {
                    globalData->m_maxClosestCheck = (int) (theOption[1].asInt ());

                } else if (theOption[0] == MString ("bspWeldThreshold"))
                {
                    globalData->m_weldThreshold = (float) (theOption[1].asFloat ());

                } else if (theOption[0] == MString ("bspVerbose"))
                {
                    globalData->m_verbose = (bool) (theOption[1].asInt ());

                } else if (theOption[0] == MString ("bspCollision"))
                {
                    globalData->m_generateCollision = (bool) (theOption[1].asInt ());
                }
                else if (theOption[0] == MString ("bspTriStrip"))
                {
                    globalData->m_triStrips = (bool) (theOption[1].asInt ());

                } else if (theOption[0] == MString ("bspTriStripper"))
                {
                    globalData->m_triStripper = (TriStripper) (theOption[1].asInt ());

                } else if (theOption[0] == MString ("bspPreLightWorld"))
                {
                    globalData->m_preLightWorld = (bool) (theOption[1].asInt ());

                } else if (theOption[0] == MString ("bspExportNormals"))
                {
                    globalData->m_exportNormals = (bool) (theOption[1].asInt ());

                } else if (theOption[0] == MString ("bspMaxSectorOverlap"))
                {
                    globalData->m_maxSectorOverlap = (float) (theOption[1].asFloat () / 100.0f);

                } else if (theOption[0] == MString ("bspNoAlphaInOveralp"))
                {
                    globalData->m_noAlphaInOverlap = (bool) (theOption[1].asInt ());

                } else if (theOption[0] == MString ("bspLimitUVs"))
                {
                    globalData->m_limitUVs = (bool) (theOption[1].asInt ());

                } else if (theOption[0] == MString ("bspUVLimit"))
                {
                    globalData->m_uvLimit = (float) (theOption[1].asFloat ());

                }
            }
        }
    }

    /*  Reset the texture warning so that it gets issued for the first
        truncated texture of each export. */
    globalData->m_textureNameWarning = true;

    /* Set the working directory to be the export
       destination */
    MDt_GetPathName ((char *) (fname.asChar ()), LTmpStr, MAXPATHLEN);

    LN = strlen (LTmpStr);
    if (LTmpStr[LN - 1] == '/')
        LTmpStr[LN - 1] = '\0';

    DtSetDirectory (LTmpStr);

    printf("\nStarting export of %s\n", SceneName);

    status = exportbsp(SceneName);	

    delete globalData;

    printf("Finished export of %s\n", SceneName);

    return status;
}

/* no read method */
bool bspTranslator::haveReadMethod () const
{
    return false;
}

/* yes we can write */
bool bspTranslator::haveWriteMethod () const
{
    return true;
}

/* what's the default extension */
MString bspTranslator::defaultExtension () const
{
    return MString("bsp");
}

bool bspTranslator::canBeOpened () const
{
    return true;
}

/* we own files with .bsp in their name */
MPxFileTranslator::MFileKind bspTranslator::identifyFile (
          const MFileObject & fileName,
          const char *buffer,
          short size) const
{
    MFileKind rval = kNotMyFileType;

    if (strstr(fileName.fullName ().asChar(), ".bsp"))
    {
        rval = kIsMyFileType;
    }
    return rval;
}

extern "C" MStatus 
initializePlugin (MObject obj)
{
    MStatus     status;
    char        bspVersion[100];
    
    sprintf(bspVersion, "3.10 - %s", __DATE__);
    
    MFnPlugin plugin (obj, "Criterion Software", bspVersion, "Any");

    /* Register the translator with the system */
    status = plugin.registerFileTranslator ("RenderWare bsp",
                            "bspTranslator.ico",
                            bspTranslator::creator,
                            "bspTranslatorOpts", "",
                            true);
    if (!status)
    {
        status.perror ("registerFileTranslator");
    }

    return status;
}

extern "C" MStatus 
uninitializePlugin (MObject obj)
{
    MStatus         status;
    MFnPlugin       plugin (obj);

    status = plugin.deregisterFileTranslator ("RenderWare bsp");
    if (!status)
    {
        status.perror ("deregisterFileTranslator");
    }

    return status;
}

#ifdef WIN32
#pragma warning(default: 4190)
#pragma warning(default: 4800)
#endif /* WIN32 */
